using System;
using Server;
using Server.Spells;
using Server.Items;
using Server.Network;

namespace Server.Mobiles
{
	//[CorpseName( "a forest elf corpse" )]
	public class WispApprentice : BaseCreature
	{
		private DateTime m_Summon = DateTime.Now;
		private bool m_Dark = false;
		
		public override bool ShowFameTitle{ get{ return false; } }
		public override bool AlwaysAttackable{ get{ return true; } }
		public override int TreasureMapLevel{ get{ return 4; } }
		public override bool CanRummageCorpses{ get{ return false; } }
		public override bool BardImmune { get { return true; } }
		public override bool Unprovokable { get { return true; } }
		public override bool Uncalmable { get { return true; } }
		
      [Constructable]
		public WispApprentice() : this( false )
		{
		}
      
      [Constructable]
		public WispApprentice( bool dark ) : base( AIType.AI_Mage, FightMode.Closest, 10, 1, 0.2, 0.4 )
		{
			m_Dark = dark;
         Hue = Utility.RandomSkinHue();
			SpeechHue = m_Dark ? 2222 : Utility.RandomDyedHue();
			EmoteHue = Utility.RandomNeutralHue();
			int OutfitHue = m_Dark ? Utility.RandomMinMax( 1103, 1109 ) : Utility.RandomMinMax( 421, 900 );
			
			if ( this.Female = Utility.RandomBool() )
			{
				Body = 0x191;
				Name = NameList.RandomName( "female" );
 				AddItem( new PlainDress( OutfitHue ) );
			}
			else
			{
				Body = 0x190;
				Name = NameList.RandomName( "male" );
 				AddItem( new Robe( OutfitHue ) );
			   Utility.AssignRandomFacialHair( this, HairHue );
			}
			// hair, facial hair
			Utility.AssignRandomHair( this );
			HairHue = DarkElf.RandomDarkElfHairHue;
			Title = "the Apprentice";
			
			SetStr( 306, 400 );
			SetDex( 100, 135 );
			SetInt( 450, 505 );

			SetDamage( 19, 29 );
			SetHits( 751, 795 );
			SetMana( 1450, 1500 );
			
			// 			SetDamageType( ResistanceType.Physical, 100 );

			SetResistance( ResistanceType.Physical, 50, 60 );
			SetResistance( ResistanceType.Fire, 50, 70 );
			SetResistance( ResistanceType.Cold, 60, 65 );
			SetResistance( ResistanceType.Poison, 55, 60 );
			SetResistance( ResistanceType.Energy, 50, 65 );

			SetSkill( SkillName.SpiritSpeak, 80.0, 100.0 );
			SetSkill( SkillName.MagicResist, 80.0, 110.0 );
			SetSkill( SkillName.Swords, 100.0, 130.0 );
			SetSkill( SkillName.Fencing, 100.0, 130.0 );
			SetSkill( SkillName.Macing, 100.0, 130.0 );
			SetSkill( SkillName.Tactics, 100.0, 130.0 );
			SetSkill( SkillName.Wrestling, 100.0, 130.0 );
			SetSkill( SkillName.Anatomy, 100.0, 110.0 );
			SetSkill( SkillName.Necromancy, 80.0, 110.0 );
			SetSkill( SkillName.Parry, 60.0, 90.0 );
			SetSkill( SkillName.Magery, 80.0, 110.0 );
			SetSkill( SkillName.EvalInt, 100.1, 120.0 );
			SetSkill( SkillName.Healing, 70.0, 90.0 );
			SetSkill( SkillName.AnimalTaming, 120.0 );
			SetSkill( SkillName.Meditation, 120.0 );
			SetSkill( SkillName.Spellweaving, 110.1, 120.0 );
			
			// outfit
			AddItem( new WizardsHat( OutfitHue ) );
			AddItem( new Shoes( OutfitHue ) );
			
			switch ( Utility.Random( 3 ))
			{
				case 0:
					{
						Item wand = new MagicArrowWand();
						wand.Movable = false;
						AddItem( wand );
					}
					break;
				case 1:
					{
						Item book = new Spellbook( (UInt64)0xFFFF );
						book.Movable = false;
						AddItem( book );
					}
					break;
			}
			//end outfit
			
    		PackReg( 2, 20 );

			Fame = 3000;
			Karma = -7000;
			VirtualArmor = 46;
		}
		
		public override void GenerateLoot()
		{
			AddLoot( LootPack.Miscellaneous );
			AddLoot( LootPack.HighScrolls, 2 );
		}
		
		public override bool IsNotScaredOfDeath{ get{ return Utility.RandomBool(); } } //neutika pri malem poctu hp - sance 50%

		public override void OnDamage( int amount, Mobile from, bool willKill, int typ )
		{
			base.OnDamage( amount, from, willKill, typ );
			
			if ( m_Dark && Utility.RandomDouble() < 0.005 )
			   Ability.FlameSpray( 6, 35, this, false );
		}
		
		public override void OnActionCombat()
		{
			if ( this.Combatant != null && DateTime.Now > m_Summon && Utility.RandomDouble() < 0.3 )
			{
				Mobile target = this.Combatant;				
				this.Frozen = false;

				Map map = this.Map;

				if ( map == null )
					return;

				BaseCreature animal = new DungeonWisp( m_Dark ? true : false );

				bool validLocation = false;
				Point3D loc = this.Location;

				for ( int j = 0; !validLocation && j < 10; ++j )
				{
					int x = X + Utility.Random( 2 ) - 1;
					int y = Y + Utility.Random( 2 ) - 1;
					int z = map.GetAverageZ( x, y );

					if ( validLocation = map.CanFit( x, y, this.Z, 16, false, false ) )
						loc = new Point3D( x, y, Z );
					else if ( validLocation = map.CanFit( x, y, z, 16, false, false ) )
						loc = new Point3D( x, y, z );
				}

				animal.Team = this.Team;
				animal.IsParagon = false;
				animal.MoveToWorld( loc, map );
				animal.Combatant = target;
				
				TimeSpan duration = TimeSpan.FromSeconds( 240.0 );
				new UnsummonTimer( this, animal, duration ).Start();
				animal.SummonEnd = DateTime.Now + duration;

				m_Summon = DateTime.Now + TimeSpan.FromSeconds( Utility.RandomMinMax( 60, 90 ) );
			}
			base.OnActionCombat();
		}
		
		public WispApprentice( Serial serial ) : base( serial )
		{
		}
		
		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			
			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			
			int version = reader.ReadInt();
			
			if ( SpeechHue == 2222 ) m_Dark = true;
		}
	}
}
